using inetsoftware.Pdfc;
using inetsoftware.Pdfc.Config;
using inetsoftware.Pdfc.Presenter;
using inetsoftware.Pdfc.Results;
using System;
using System.Collections.Generic;

namespace inetsoftware.PdfcSamples
{
    /// <summary>
    /// A simple sample for using regular expressions for filtering which texts are to be compared.
    /// Expects 2 arguments - the paths of the PDF files
    /// </summary>
    public class UseRegex
    {
        static UseRegex()
        {
            // Activate the license once from environment if required.
            string key = Environment.GetEnvironmentVariable("PDFC_KEY");
            if (!string.IsNullOrEmpty(key))
            {
                PDFC.ActivateLicense(key);
            }
        }

        /// <summary>
        /// Start the sample, that show how using regular expressions for filtering which texts are to be compared.
        /// </summary>
        /// <param name="args">Expected 2 arguments, the path of the PDF files</param>
        public static void Main(string[] args)
        {
            if (args == null || args.Length != 2)
            {
                throw new ArgumentException("Usage: <executable> <PDF-File1> <PDF-File2>");
            }

            PDFComparer pdfComparer = new PDFComparer();

            System.Console.WriteLine("\nFiltered ");
            IDictionary<string,string> profile = new Dictionary<string,string>();

            // IMPORTANT: These profile properties will only have an effect if the plugin 'filter.regex.zip'
            // is present in the plugins folder of the project and if the plugin is active in the configuration, which is the case by default.

            profile.Add(PDFCProperty.FILTER_PATTERNS, ""
                            //for removing all numbers that are not in a text
                            + "\\s\\d+$|regexp|active\n"
                            + "^\\d+\\s|regexp|active\n"
                            + "\\s\\d+\\s|regexp|active\n"
                            + "^\\d+$|regexp|active\n"
                            //filtered date in format YYYY mm dd and dd mm YYYY
                            + "((19|20)\\d\\d([- /.])(0[1-9]|1[012])([- /.])(0[1-9]|[12][0-9]|3[01]))|regexp|active\n"
                            + "((0[1-9]|[12][0-9]|3[01])[- /.](0[1-9]|1[012])[- /.](19|20)\\d\\d)|regexp|active\n"
                            //filtered length unit
                            + "\\s(mm|cm|dm|m|km)|regexp|active\n"
            );
            profile.Add(PDFCProperty.FILTERS, "REGEXP");

            pdfComparer.AddPresenter(new ConsolePresenter());
            pdfComparer.SetProfile(profile);
            using (pdfComparer.Compare(args[0], args[1]))
            { }
        }
    }
}
